/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr.appletssl;

public class SHA1 {
    private int[] state = new int[5];
    private byte[] msgBlock = new byte[64];
    private int msgBlockIndex;
    private long count;
    private static final int[] K = new int[]{1518500249, 1859775393, -1894007588, -899497514};
    private byte[] ONE_BYTE = new byte[1];

    public void init() {
        this.count = 0L;
        this.msgBlockIndex = 0;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
    }

    public void update(byte[] buf, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.msgBlock[this.msgBlockIndex++] = buf[offset + i];
            this.count += 8L;
            if (this.msgBlockIndex != 64) continue;
            this.processMessageBlock();
        }
    }

    public void update(byte b) {
        this.ONE_BYTE[0] = b;
        this.update(this.ONE_BYTE, 0, 1);
    }

    private void processMessageBlock() {
        int temp;
        int t;
        int[] W = new int[80];
        for (t = 0; t < 16; ++t) {
            W[t] = (this.msgBlock[t * 4] & 0xFF) << 24;
            int n = t;
            W[n] = W[n] | (this.msgBlock[t * 4 + 1] & 0xFF) << 16;
            int n2 = t;
            W[n2] = W[n2] | (this.msgBlock[t * 4 + 2] & 0xFF) << 8;
            int n3 = t;
            W[n3] = W[n3] | this.msgBlock[t * 4 + 3] & 0xFF;
        }
        for (t = 16; t < 80; ++t) {
            W[t] = this.circularShift(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
        }
        int A = this.state[0];
        int B = this.state[1];
        int C = this.state[2];
        int D = this.state[3];
        int E = this.state[4];
        for (t = 0; t < 20; ++t) {
            temp = this.circularShift(A, 5) + (B & C | ~B & D) + E + W[t] + K[0];
            E = D;
            D = C;
            C = this.circularShift(B, 30);
            B = A;
            A = temp;
        }
        for (t = 20; t < 40; ++t) {
            temp = this.circularShift(A, 5) + (B ^ C ^ D) + E + W[t] + K[1];
            E = D;
            D = C;
            C = this.circularShift(B, 30);
            B = A;
            A = temp;
        }
        for (t = 40; t < 60; ++t) {
            temp = this.circularShift(A, 5) + (B & C | B & D | C & D) + E + W[t] + K[2];
            E = D;
            D = C;
            C = this.circularShift(B, 30);
            B = A;
            A = temp;
        }
        for (t = 60; t < 80; ++t) {
            temp = this.circularShift(A, 5) + (B ^ C ^ D) + E + W[t] + K[3];
            E = D;
            D = C;
            C = this.circularShift(B, 30);
            B = A;
            A = temp;
        }
        this.state[0] = this.state[0] + A;
        this.state[1] = this.state[1] + B;
        this.state[2] = this.state[2] + C;
        this.state[3] = this.state[3] + D;
        this.state[4] = this.state[4] + E;
        this.msgBlockIndex = 0;
    }

    private void padMessage() {
        if (this.msgBlockIndex > 55) {
            this.msgBlock[this.msgBlockIndex++] = -128;
            while (this.msgBlockIndex < 64) {
                this.msgBlock[this.msgBlockIndex++] = 0;
            }
            this.processMessageBlock();
            while (this.msgBlockIndex < 56) {
                this.msgBlock[this.msgBlockIndex++] = 0;
            }
        } else {
            this.msgBlock[this.msgBlockIndex++] = -128;
            while (this.msgBlockIndex < 56) {
                this.msgBlock[this.msgBlockIndex++] = 0;
            }
        }
        this.msgBlock[56] = (byte)(this.count >>> 56 & 0xFFL);
        this.msgBlock[57] = (byte)(this.count >>> 48 & 0xFFL);
        this.msgBlock[58] = (byte)(this.count >>> 40 & 0xFFL);
        this.msgBlock[59] = (byte)(this.count >>> 32 & 0xFFL);
        this.msgBlock[60] = (byte)(this.count >>> 24 & 0xFFL);
        this.msgBlock[61] = (byte)(this.count >>> 16 & 0xFFL);
        this.msgBlock[62] = (byte)(this.count >>> 8 & 0xFFL);
        this.msgBlock[63] = (byte)(this.count & 0xFFL);
        this.processMessageBlock();
    }

    public void dump(byte[] digest, int offset) {
        int i;
        this.padMessage();
        for (i = 0; i < 64; ++i) {
            this.msgBlock[i] = 0;
        }
        this.count = 0L;
        for (i = 0; i < 20; ++i) {
            digest[offset + i] = (byte)(this.state[i >>> 2] >>> 8 * (3 - (i & 3)));
        }
        this.init();
    }

    private int circularShift(int i, int bits) {
        return i << bits | i >>> 32 - bits;
    }
}

